<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
?>

<!DOCTYPE html>
<html lang="en">

    <head>
        <title><?php echo isset($page_title) ? $page_title : "IBO PRO"; ?></title>
        <meta charset="utf-8" />
        <meta name="description" content="MaxRebrands IBO Panel" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <link rel="shortcut icon" href="<?php echo $static_url; ?>media/logos/logo.png" />
		<link href="<?php echo $static_url; ?>plugins/global/plugins.bundle.css" rel="stylesheet" />
		<link href="<?php echo $static_url; ?>css/style.bundle.css" rel="stylesheet" />
        
        <style>
            /* --- MELHORIA EXCLUSIVA DO CARD --- */
            .login-card-premium {
                background: rgba(255, 255, 255, 0.01);
                border: 1px solid rgba(120, 120, 120, 0.1);
                border-radius: 24px;
                padding: 3rem !important;
                box-shadow: 0 15px 35px rgba(0, 0, 0, 0.03);
                transition: all 0.3s ease;
            }
            
            [data-bs-theme="dark"] .login-card-premium {
                background: rgba(20, 20, 22, 0.4);
                border: 1px solid rgba(255, 255, 255, 0.05);
                box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            }

            .form-control-modern {
                border-radius: 14px !important;
                padding: 14px 20px !important;
                border: 1px solid rgba(120, 120, 120, 0.2) !important;
                background: transparent !important;
                transition: all 0.3s ease !important;
            }

            .form-control-modern:focus {
                border-color: #009ef7 !important;
                background: rgba(0, 158, 247, 0.02) !important;
                box-shadow: 0 0 10px rgba(0, 158, 247, 0.1) !important;
            }

            .btn-login-modern {
                border-radius: 14px !important;
                font-weight: 700 !important;
                letter-spacing: 1px;
                padding: 14px !important;
                transition: all 0.3s ease !important;
                text-transform: uppercase;
            }

            .btn-login-modern:hover {
                transform: translateY(-2px);
                box-shadow: 0 8px 20px rgba(0, 158, 247, 0.3);
            }

            /* Posicionamento do Seletor no Topo */
            .theme-selector-top {
                position: absolute;
                top: 30px;
                right: 30px;
                z-index: 10;
            }
            /* ---------------------------------- */
        </style>
    </head>

    <body id="kt_body" class="app-blank">
		<script>var defaultThemeMode = "light"; var themeMode; if ( document.documentElement ) { if ( document.documentElement.hasAttribute("data-bs-theme-mode")) { themeMode = document.documentElement.getAttribute("data-bs-theme-mode"); } else { if ( localStorage.getItem("data-bs-theme") !== null ) { themeMode = localStorage.getItem("data-bs-theme"); } else { themeMode = defaultThemeMode; } } if (themeMode === "system") { themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light"; } document.documentElement.setAttribute("data-bs-theme", themeMode); }</script>
		
		<div class="d-flex flex-column flex-root" id="kt_app_root">
			<div class="d-flex flex-column flex-column-fluid">
				
				<div class="d-flex flex-column flex-column-fluid p-10 position-relative">
					
                    <div class="theme-selector-top">
                        <div class="d-flex flex-row align-items-center">
                            <span class="theme-light-show fs-7 fw-bold me-3 text-gray-700">
                                <i class="ki-outline ki-night-day fs-2 me-1"></i>Modo Escuro
                            </span>
                            <span class="theme-dark-show fs-7 fw-bold text-white me-3">
                                <i class="ki-outline ki-moon fs-2 me-1"></i>Modo Claro
                            </span>
                            <div data-bs-theme="dark">
                                <div class="form-check form-switch form-check-custom form-check-solid">
                                    <input class="form-check-input h-20px w-40px" type="checkbox" value="1" id="kt_sidebar_theme_mode_toggle" />
                                </div>
                            </div>
                        </div>
                    </div>

					<div class="d-flex flex-center flex-column flex-column-fluid">
						
						<div class="w-lg-500px login-card-premium">
							<form class="form w-100" novalidate="novalidate" id="kt_sign_in_form" data-kt-redirect-url="index.html" action="#">
								<div class="text-center mb-11">
                                    <img alt="Logo" src="<?php echo $static_url; ?>media/logos/logo.png" class="h-150px h-lg-180px mb-5" />
                                    <h1 class="text-gray-900 fw-bolder mb-3 fs-2x theme-light-show">IBO PRO</h1>
                                    <h1 class="text-white fw-bolder mb-3 fs-2x theme-dark-show">IBO PRO</h1>
								</div>

								<div class="fv-row mb-8">
									<input type="text" placeholder="Username" name="username" autocomplete="off" class="form-control form-control-modern" />
								</div>

								<div class="fv-row mb-7">
									<input type="password" placeholder="Password" name="password" autocomplete="off" class="form-control form-control-modern" />
								</div>

								<div class="d-grid mb-5">
									<button type="submit" id="kt_sign_in_submit" class="btn btn-primary btn-login-modern">
										<span class="indicator-label">ENTRAR</span>
										<span class="indicator-progress">Aguarde... 
										<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
									</button>
								</div>
							</form>
						</div>

					</div>

				</div>

			</div>
		</div>

        <script src="<?php echo $static_url; ?>plugins/global/plugins.bundle.js"></script>
        <script src="<?php echo $static_url; ?>js/scripts.bundle.js"></script>
        <script src="<?php echo $static_url; ?>js/users.js"></script>
	</body>
</html>