<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
$current_page = basename($_SERVER['PHP_SELF']);
$accordion_active = ($current_page == 'themes.php' || $current_page == 'ajustescores.php') ? 'show' : '';
?>

<style>
    /* --- TEMA CINZA GRAFITE SÓLIDO (ESTILO CONSÓRCIO) --- */
    .app-sidebar {
        background-color: #151515 !important; /* Cinza Grafite Profundo */
        background-image: none !important;
        backdrop-filter: none !important;
        border-right: 1px solid #222222 !important;
    }

    /* Ajuste para o Menu e Títulos no modo Grafite */
    .app-sidebar .menu-title, 
    .app-sidebar .menu-heading,
    .app-sidebar .menu-arrow,
    .app-sidebar i {
        color: #ffffff !important;
    }

    /* --- FORÇANDO BRANCO PURO NO MODO LIGHT --- */
    [data-bs-theme="light"] .app-sidebar {
        background-color: #ffffff !important;
        border-right: 1px solid #eff2f5 !important;
    }
    
    [data-bs-theme="light"] .app-sidebar .menu-title, 
    [data-bs-theme="light"] .app-sidebar .menu-heading,
    [data-bs-theme="light"] .app-sidebar .menu-arrow,
    [data-bs-theme="light"] .app-sidebar i,
    [data-bs-theme="light"] .theme-label-text {
        color: #000000 !important;
    }

    /* Destaque Azul no Grafite */
    .menu-item .menu-link.active {
        background: #009ef7 !important;
        color: #ffffff !important;
        box-shadow: 0 4px 10px rgba(0, 158, 247, 0.2);
    }

    /* Badge pulsante */
    .badge-pulse {
        display: inline-block;
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background: #50cd89;
        margin-left: 8px;
        animation: pulse-green 2s infinite;
    }

    @keyframes pulse-green {
        0% { box-shadow: 0 0 0 0 rgba(80, 205, 137, 0.7); }
        70% { box-shadow: 0 0 0 10px rgba(80, 205, 137, 0); }
        100% { box-shadow: 0 0 0 0 rgba(80, 205, 137, 0); }
    }

    /* Seletor dentro do Menu */
    .menu-theme-selector {
        padding: 12px 15px;
        margin-top: 15px;
        border-top: 1px solid rgba(255, 255, 255, 0.05);
    }
    [data-bs-theme="light"] .menu-theme-selector {
        border-top: 1px solid rgba(0, 0, 0, 0.05);
    }

    #active-user-count {
        font-size: 0.75rem;
        margin-left: 5px;
        font-weight: 800;
        color: #50cd89 !important;
    }
</style>

<div id="kt_app_sidebar" class="app-sidebar" data-kt-drawer="true" data-kt-drawer-name="app-sidebar"
    data-kt-drawer-activate="{default: true, lg: false}" data-kt-drawer-overlay="true" data-kt-drawer-width="250px"
    data-kt-drawer-direction="start" data-kt-drawer-toggle="#kt_app_sidebar_toggle">

    <div class="d-none d-lg-flex flex-center px-6 pt-10 pb-10" id="kt_app_sidebar_header">
        <a href="dns.php">
            <img alt="Logo" src="<?php echo $static_url; ?>media/logos/logo.png" class="h-50px" />
        </a>
    </div>

    <div class="flex-grow-1">
        <div id="kt_app_sidebar_menu_wrapper" class="hover-scroll-y" data-kt-scroll="true" data-kt-scroll-height="auto"
            data-kt-scroll-dependencies="#kt_app_sidebar_header" data-kt-scroll-offset="20px">
            <div class="app-sidebar-navs-default px-5 mb-10">
                <div id="#kt_app_sidebar_menu" data-kt-menu="true" data-kt-menu-expand="false"
                    class="menu menu-column menu-rounded menu-sub-indention">
                    
                    <div class="menu-item pb-0 pt-0">
                        <div class="menu-content">
                            <span class="menu-heading fw-bold text-uppercase fs-8 ls-1">📊 Dashboard</span>
                        </div>
                    </div>
                    
                    <div class="separator mb-4 mx-4 opacity-20"></div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page == 'dns.php') ? 'active' : ''; ?>" href="dns.php">
                            <span class="menu-title">🌐 Adicionar DNS</span>
                        </a>
                    </div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page == 'mac.php') ? 'active' : ''; ?>" href="mac.php">
                            <span class="menu-title">👥 Usuarios Ativos <span class="badge-pulse"></span> <span id="active-user-count">...</span></span>
                        </a>
                    </div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page == 'ads.php') ? 'active' : ''; ?>" href="ads.php">
                            <span class="menu-title">📤 Anuncio Banner</span>
                        </a>
                    </div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page == 'modobanner.php') ? 'active' : ''; ?>" href="modobanner.php">
                            <span class="menu-title">⚙️ Modelo de Banner</span>
                        </a>
                    </div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page == 'note.php') ? 'active' : ''; ?>" href="note.php">
                            <span class="menu-title">📢 Mensagem Servidor</span>
                        </a>
                    </div>

                    <div data-kt-menu-trigger="click" class="menu-item <?php echo $accordion_active ? 'here show' : ''; ?> menu-accordion">
                        <span class="menu-link">
                            <span class="menu-title">🎨 Personalização</span>
                            <span class="menu-arrow"></span>
                        </span>
                        <div class="menu-sub menu-sub-accordion">
                            <div class="menu-item">
                                <a class="menu-link <?php echo ($current_page == 'themes.php') ? 'active' : ''; ?>" href="themes.php">
                                    <span class="menu-bullet"><span class="bullet bullet-dot"></span></span>
                                    <span class="menu-title">🎭 Temas Aplicativo</span>
                                </a>
                            </div>
                            <div class="menu-item">
                                <a class="menu-link <?php echo ($current_page == 'ajustescores.php') ? 'active' : ''; ?>" href="ajustescores.php">
                                    <span class="menu-bullet"><span class="bullet bullet-dot"></span></span>
                                    <span class="menu-title">🎨 Cores Botões <span class="badge badge-light-primary fw-bold fs-9 px-2 py-1 ms-2">NOVO</span></span>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page == 'qrcode.php') ? 'active' : ''; ?>" href="qrcode.php">
                            <span class="menu-title">🔳 Enviar QR Code</span>
                        </a>
                    </div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page == 'qr_url.php') ? 'active' : ''; ?>" href="qr_url.php">
                            <span class="menu-title">🧾 Texto QR Code</span>
                        </a>
                    </div>

                    <div class="menu-item">
                        <a class="menu-link <?php echo ($current_page == 'users.php') ? 'active' : ''; ?>" href="users.php">
                            <span class="menu-title">👤 Meu Perfil</span>
                        </a>
                    </div>

                    <div class="menu-theme-selector d-flex flex-stack">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                                <i class="ki-outline ki-night-day fs-2 theme-light-show"></i>
                                <i class="ki-outline ki-moon fs-2 theme-dark-show"></i>
                            </div>
                            <span class="theme-label-text fs-7 fw-bold">Modo Visual</span>
                        </div>
                        <div class="form-check form-switch form-check-custom form-check-solid">
                            <input class="form-check-input h-20px w-40px" type="checkbox" value="1" id="kt_sidebar_theme_mode_toggle" />
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function syncActiveUsers() {
        fetch('actions/user_actions.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'view' })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success && data.data) {
                const count = data.data.length;
                document.getElementById('active-user-count').innerText = `(${count})`;
            }
        })
        .catch(error => console.error('Erro na sincronização:', error));
    }

    document.addEventListener("DOMContentLoaded", function() {
        syncActiveUsers();
        setInterval(syncActiveUsers, 10000);
    });
</script>