<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
?>

<!DOCTYPE html>
<html lang="pt-br">

<head>
    <title><?php echo isset($page_title) ? $page_title : "IBO PRO"; ?></title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="shortcut icon" href="<?php echo $static_url; ?>media/logos/logo.png" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
    <link href="<?php echo $static_url; ?>plugins/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet" />
    <link href="<?php echo $static_url; ?>plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" />
    <link href="<?php echo $static_url; ?>plugins/global/plugins.bundle.css" rel="stylesheet" />
    <link href="<?php echo $static_url; ?>css/style.bundle.css" rel="stylesheet" />

    <style>
        /* --- FUNDO AMBIENTE --- */
        body {
            background-color: #f4f7f9;
            background-image: 
                radial-gradient(at 0% 0%, rgba(0, 158, 247, 0.04) 0px, transparent 45%),
                radial-gradient(at 100% 100%, rgba(114, 57, 234, 0.04) 0px, transparent 45%);
            transition: background 0.4s ease;
        }
        [data-bs-theme="dark"] body {
            background-color: #0c0c12;
            background-image: 
                radial-gradient(at 0% 0%, rgba(0, 158, 247, 0.07) 0px, transparent 45%),
                radial-gradient(at 100% 100%, rgba(114, 57, 234, 0.07) 0px, transparent 45%);
        }

        /* --- FOOTER GLASS --- */
        .app-footer {
            background: rgba(255, 255, 255, 0.4) !important;
            backdrop-filter: blur(12px);
            border-top: 1px solid rgba(0, 0, 0, 0.03) !important;
        }
        [data-bs-theme="dark"] .app-footer {
            background: rgba(20, 20, 31, 0.4) !important;
            border-top: 1px solid rgba(255, 255, 255, 0.03) !important;
        }

        .status-badge {
            display: flex; align-items: center; gap: 8px;
            background: rgba(80, 205, 137, 0.1);
            color: #50cd89; padding: 4px 12px; border-radius: 20px;
            font-size: 11px; font-weight: 700;
        }
        .status-dot { width: 6px; height: 6px; background: #50cd89; border-radius: 50%; box-shadow: 0 0 8px #50cd89; }
    </style>
</head>

<body id="kt_app_body" data-kt-app-sidebar-enabled="true" data-kt-app-sidebar-fixed="true"
    data-kt-app-sidebar-push-header="true" data-kt-app-sidebar-push-toolbar="true"
    data-kt-app-sidebar-push-footer="true" class="app-default">
    
    <script>var defaultThemeMode = "light"; var themeMode; if (document.documentElement) { if (document.documentElement.hasAttribute("data-bs-theme-mode")) { themeMode = document.documentElement.getAttribute("data-bs-theme-mode"); } else { if (localStorage.getItem("data-bs-theme") !== null) { themeMode = localStorage.getItem("data-bs-theme"); } else { themeMode = defaultThemeMode; } } if (themeMode === "system") { themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light"; } document.documentElement.setAttribute("data-bs-theme", themeMode); }</script>
    
    <div class="d-flex flex-column flex-root app-root" id="kt_app_root">
        <div class="app-page flex-column flex-column-fluid" id="kt_app_page">
            <?php include 'includes/header.php'; ?>
            <div class="app-wrapper flex-column flex-row-fluid" id="kt_app_wrapper">
            <?php include 'includes/sidebar.php'; ?>
                <div class="app-main flex-column flex-row-fluid" id="kt_app_main">
                    <div class="d-flex flex-column flex-column-fluid">
                        <div id="kt_app_content" class="app-content flex-column-fluid">
                            <div id="kt_app_content_container" class="app-container container-fluid">
                                <?php echo isset($page_content) ? $page_content : "<div class='text-center py-20 opacity-50'><i class='ki-outline ki-folder-search fs-5x'></i><h1 class='mt-5'>Nenhum conteúdo carregado</h1></div>"; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div id="kt_app_footer" class="app-footer">
                        <div class="app-container container-fluid d-flex flex-column flex-md-row flex-center flex-md-stack py-3">
                            <div class="text-gray-900 order-2 order-md-1 d-flex align-items-center">
                                <span class="text-muted fw-bold me-2">2026©</span>
                                <span class="text-gray-800 fw-bold me-5">IBO PRO</span>
                                <div class="status-badge">
                                    <span class="status-dot"></span> SISTEMA ONLINE
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
        <i class="ki-outline ki-arrow-up fs-1"></i>
    </div>

    <script src="<?php echo $static_url; ?>plugins/global/plugins.bundle.js"></script>
    <script src="<?php echo $static_url; ?>js/scripts.bundle.js"></script>
    <script src="<?php echo $static_url; ?>plugins/custom/datatables/datatables.bundle.js"></script>
</body>
</html>