<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>TMDB Pure Elite v7.0</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --accent: #E50914;
            --glass: rgba(0, 0, 0, 0.7);
            --border: rgba(255, 255, 255, 0.12);
            --star: #FFD700;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Plus Jakarta Sans', sans-serif; }
        body { background: #000; color: #fff; overflow: hidden; height: 100vh; }

        .showcase { 
            position: relative; 
            width: 100%; 
            height: 100vh; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
        }

        /* Efeito de Fundo */
        .bg-image {
            position: absolute;
            inset: 0;
            background-size: cover;
            background-position: center;
            transition: opacity 1.2s ease-in-out;
            opacity: 0;
            filter: brightness(0.4) saturate(1.2);
            transform: scale(1.15);
        }

        .bg-image.visible { 
            opacity: 1; 
            transform: scale(1.02);
            transition: opacity 1.2s ease-in-out, transform 8s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        .overlay {
            position: absolute;
            inset: 0;
            background: radial-gradient(circle at center, transparent 10%, rgba(0,0,0,0.85) 100%);
            z-index: 1;
        }

        /* Card Central */
        .details-panel {
            position: relative;
            z-index: 10;
            max-width: 550px;
            width: 85%;
            padding: 40px 30px;
            text-align: center;
            background: var(--glass);
            backdrop-filter: blur(30px) saturate(160%);
            -webkit-backdrop-filter: blur(30px) saturate(160%);
            border: 1px solid var(--border);
            border-radius: 35px;
            box-shadow: 0 40px 100px rgba(0,0,0,0.8);
            transition: all 0.7s cubic-bezier(0.19, 1, 0.22, 1);
        }

        .details-panel.hidden { 
            opacity: 0; 
            transform: scale(0.95) translateY(10px); 
            filter: blur(8px);
        }

        .category-label {
            color: var(--accent);
            text-transform: uppercase;
            letter-spacing: 6px;
            font-size: 0.7rem;
            font-weight: 800;
            margin-bottom: 12px;
            display: inline-block;
        }

        .panel-title {
            font-size: clamp(1.8rem, 4vw, 2.6rem);
            font-weight: 800;
            margin-bottom: 15px;
            line-height: 1.1;
            letter-spacing: -1.5px;
            background: linear-gradient(to bottom, #fff, #bbb);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .panel-metadata {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            font-size: 0.85rem;
            color: rgba(255,255,255,0.6);
            font-weight: 500;
        }

        .metadata-rating {
            color: var(--star);
            background: rgba(255, 255, 255, 0.08);
            padding: 4px 12px;
            border-radius: 50px;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .live-badge {
            background: var(--accent);
            padding: 2px 8px;
            border-radius: 4px;
            font-size: 0.6rem;
            font-weight: 900;
            margin-left: 5px;
            vertical-align: middle;
        }

        /* Barra de Progresso Inferior */
        .progress-bar {
            position: absolute;
            bottom: 0;
            left: 0;
            height: 3px;
            background: var(--accent);
            width: 0%;
            z-index: 20;
            opacity: 0.8;
            box-shadow: 0 0 10px var(--accent);
        }
    </style>
</head>
<body>
    <div class="showcase">
        <div id="bg1" class="bg-image visible"></div>
        <div id="bg2" class="bg-image"></div>
        <div class="overlay"></div>
        
        <div id="details-panel" class="details-panel">
            <span id="label-type" class="category-label">EXCLUSIVE SELECTION</span>
            <h1 id="panel-title" class="panel-title">Iniciando...</h1>
            <div id="panel-metadata" class="panel-metadata"></div>
        </div>

        <div id="loader" class="progress-bar"></div>
    </div>

    <script>
        const apiKey = '8c0267e0f9ec706130cc4ed8a91cb056';
        const imageBaseUrl = 'https://image.tmdb.org/t/p/original';
        
        let displayList = [];
        let current = 0;
        let showingBg1 = true;
        let rotateInterval;

        async function fetchAll() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/trending/all/day?api_key=${apiKey}&language=pt-BR`);
                const data = await response.json();
                
                displayList = data.results
                    .filter(i => i.backdrop_path)
                    .sort(() => Math.random() - 0.5)
                    .slice(0, 15);

                rotate();
                startTimer();
            } catch (e) {
                console.error("Erro na conexão");
            }
        }

        function startTimer() {
            rotateInterval = setInterval(rotate, 7000);
        }

        function rotate() {
            if (displayList.length === 0) return;
            
            const item = displayList[current];
            const panel = document.getElementById('details-panel');
            const loader = document.getElementById('loader');
            
            panel.classList.add('hidden');
            loader.style.transition = 'none';
            loader.style.width = '0%';

            setTimeout(() => {
                const nextBg = showingBg1 ? document.getElementById('bg2') : document.getElementById('bg1');
                const currBg = showingBg1 ? document.getElementById('bg1') : document.getElementById('bg2');

                nextBg.style.backgroundImage = `url(${imageBaseUrl}${item.backdrop_path})`;
                currBg.classList.remove('visible');
                nextBg.classList.add('visible');

                const year = (item.release_date || item.first_air_date || '2026').slice(0, 4);
                let typeLabel = (item.media_type === 'tv' ? "SÉRIE" : "FILME");

                document.getElementById('label-type').innerHTML = `
                    ${typeLabel} • ${year} ${year == '2026' ? '<span class="live-badge">NEW</span>' : ''}
                `;
                
                document.getElementById('panel-title').textContent = item.title || item.name;
                document.getElementById('panel-metadata').innerHTML = `
                    <div class="metadata-rating">
                        <i class="fa-solid fa-star"></i> ${item.vote_average.toFixed(1)}
                    </div>
                    <span>•</span>
                    <span>4K UHD</span>
                    <span>•</span>
                    <span style="text-transform: uppercase;">${item.original_language}</span>
                `;

                panel.classList.remove('hidden');
                
                setTimeout(() => {
                    loader.style.transition = 'width 6.5s linear';
                    loader.style.width = '100%';
                }, 50);
                
                showingBg1 = !showingBg1;
                current = (current + 1) % displayList.length;
            }, 700);
        }

        fetchAll();
    </script>
</body>
</html>